#pragma once

void setupMotor()
{
	pinMode(PIN_MOTOR_LEFT_1, OUTPUT);
	pinMode(PIN_MOTOR_LEFT_2, OUTPUT);
	pinMode(PIN_MOTOR_RIGHT_1, OUTPUT);
	pinMode(PIN_MOTOR_RIGHT_2, OUTPUT);
	pinMode(PIN_SLEEP, OUTPUT);

	ledcSetup(LEDC_CH_MOTOR_LEFT, MOTOR_PWM_FREQ, MOTOR_PWM_RESOLUTION);
	ledcSetup(LEDC_CH_MOTOR_RIGHT, MOTOR_PWM_FREQ, MOTOR_PWM_RESOLUTION);

	digitalWrite(PIN_SLEEP, HIGH);
}

void moveMotor(int16_t speed)
{
	if (speed >= 0 && speed <= MOTOR_PWM_MAX)
	{
		ledcDetachPin(PIN_MOTOR_LEFT_2);
		ledcDetachPin(PIN_MOTOR_RIGHT_2);

		ledcAttachPin(PIN_MOTOR_LEFT_1, LEDC_CH_MOTOR_LEFT);
		ledcAttachPin(PIN_MOTOR_RIGHT_1, LEDC_CH_MOTOR_RIGHT);
		
		ledcWrite(LEDC_CH_MOTOR_LEFT, speed);
		digitalWrite(PIN_MOTOR_LEFT_2, LOW);
		ledcWrite(LEDC_CH_MOTOR_RIGHT, speed);
		digitalWrite(PIN_MOTOR_RIGHT_2, LOW);
	}
	else if (speed < 0 && speed >= -MOTOR_PWM_MAX)
	{
		ledcDetachPin(PIN_MOTOR_LEFT_1);
		ledcDetachPin(PIN_MOTOR_RIGHT_1);

		ledcAttachPin(PIN_MOTOR_LEFT_2, LEDC_CH_MOTOR_LEFT);
		ledcAttachPin(PIN_MOTOR_RIGHT_2, LEDC_CH_MOTOR_RIGHT);

		digitalWrite(PIN_MOTOR_LEFT_1, LOW);
		ledcWrite(LEDC_CH_MOTOR_LEFT, abs(speed));
		digitalWrite(PIN_MOTOR_RIGHT_1, LOW);
		ledcWrite(LEDC_CH_MOTOR_RIGHT, abs(speed));
	}
}

