#pragma once

#include <Arduino.h>

//P I N   D E C L A R A T I O N

// I2C
static constexpr uint8_t PIN_SCL 					= 1;
static constexpr uint8_t PIN_SDA 					= 2;

// ultra-sonic sensor
static constexpr uint8_t PIN_TRIGGER 				= 3;
static constexpr uint8_t PIN_ECHO 					= 4;

// line-follow sensor
static constexpr uint8_t PIN_REFLECTION_SENSOR_1 	= 5;
static constexpr uint8_t PIN_REFLECTION_SENSOR_2 	= 6;
static constexpr uint8_t PIN_REFLECTION_SENSOR_3 	= 7;
static constexpr uint8_t PIN_REFLECTION_SENSOR_4 	= 8;
static constexpr uint8_t PIN_REFLECTION_SENSOR_5 	= 9;
static constexpr uint8_t PIN_REFLECTION_SENSOR_6 	= 10;
static constexpr uint8_t PIN_REFLECTION_SENSOR_7 	= 11;
static constexpr uint8_t PIN_REFLECTION_SENSOR_8 	= 12;

// headlights
static constexpr uint8_t PIN_LED_WHITE_LEFT 		= 13;
static constexpr uint8_t PIN_LED_WHITE_RIGHT 		= 18;

// backlights
static constexpr uint8_t PIN_LED_RED_LEFT 			= 37;
static constexpr uint8_t PIN_LED_RED_RIGHT 			= 38;

// battery-voltage
static constexpr uint8_t PIN_VOLTAGE_MEASURE 		= 14;

// motor driver
static constexpr uint8_t PIN_FAULT 					= 15;
static constexpr uint8_t PIN_SLEEP 					= 21;
static constexpr uint8_t PIN_MOTOR_RIGHT_1 			= 34;
static constexpr uint8_t PIN_MOTOR_RIGHT_2 			= 33;
static constexpr uint8_t PIN_MOTOR_LEFT_1 			= 36;
static constexpr uint8_t PIN_MOTOR_LEFT_2 			= 35;

// servo
static constexpr uint8_t PIN_SERVO 					= 17;

// user buttons
static constexpr uint8_t PIN_BUTTON_2 				= 39;
static constexpr uint8_t PIN_BUTTON_1 				= 40;

/*******************************************************/


// pwm channels
static constexpr uint8_t LEDC_CH_MOTOR_LEFT		= 2;
static constexpr uint8_t LEDC_CH_MOTOR_RIGHT	= 3;

static constexpr uint16_t MOTOR_PWM_FREQ 		= 1000;
static constexpr uint8_t MOTOR_PWM_RESOLUTION	= 8;
static constexpr uint8_t MOTOR_PWM_MAX 			= 255;


// servo limits
static constexpr uint8_t SERVO_MIN 	= 60;
static constexpr uint8_t SERVO_MAX 	= 120;

static constexpr uint16_t SERVO_MID = 1309;


// reflection sensor
static constexpr uint16_t NUMBER_OF_REFLECTION_SENSORS	 = 8;
static constexpr uint16_t REFLECTION_SENSOR_THRESHOLD 	= 7000;

// battery voltage
static constexpr double BATTERY_VOLTAGE_MULTIPLIER 	= 3.7;
static constexpr uint16_t MINIMUM_BATTERY_VOLTAGE	= 6200;		// Voltage in mV
