#pragma once
#include "config.h"

void setupBatteryVoltage()
{
	pinMode(PIN_VOLTAGE_MEASURE, INPUT);
}

uint32_t readbatteryVoltage()
{
	return analogReadMilliVolts(PIN_VOLTAGE_MEASURE) * BATTERY_VOLTAGE_MULTIPLIER;
}

void startAutomaticBatteryProtection()
{	
	setupBatteryVoltage();
	xTaskCreate(
		[](void* o)
		{
			while (1)
			{
				if(readbatteryVoltage() < MINIMUM_BATTERY_VOLTAGE)
				{
					delay(1000);
					if(readbatteryVoltage() < MINIMUM_BATTERY_VOLTAGE)
					{
						Serial.println("Battery voltage is too low. Going to sleep.");
						pinMode(PIN_SLEEP, OUTPUT);
						digitalWrite(PIN_SLEEP, LOW);
						ESP.deepSleep(-1);
					}
				}
				delay(10000);
				
			}
		},     								
		"automatic battery protection",  	
		2048,       						
		NULL,       						
		1,          						
		NULL								
	);
}